/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.MapRenderer;
import editor.Notepad;
import editor.ObjectPopup;
import editor.history.Action;
import game.core.MapData;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.BigGuard;
import game.core.mechanics.character.Citizen;
import game.core.mechanics.character.Dog;
import game.core.mechanics.character.Dwarf;
import game.core.mechanics.character.Guard;
import game.core.mechanics.dialog.Dialog;
import game.core.mechanics.objects.AnimationObject;
import game.core.mechanics.objects.Destructible;
import game.core.mechanics.objects.Moveable;
import game.core.mechanics.objects.Trigger;
import game.core.mechanics.objects.trigger.Checkpoint;
import game.core.mechanics.objects.trigger.DialogTrigger;
import game.core.mechanics.objects.trigger.DoorTrigger;
import game.core.mechanics.objects.trigger.MessageTrigger;
import game.core.mechanics.objects.trigger.OwlTrigger;
import game.core.mechanics.objects.usable.Chest;
import game.core.mechanics.objects.usable.Key;
import game.core.mechanics.objects.usable.Potion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.newdawn.slick.CanvasGameContainer;
import org.newdawn.slick.SlickException;

public class MapEditor
extends JFrame {
    private MapData mapData;
    private CanvasGameContainer mapCanvas;
    private MapRenderer mapRenderer;
    ButtonGroup group;
    private ArrayList<Action> history = new ArrayList();
    IGameEntity currentEntity;
    int currentX;
    int currentY;
    private ObjectPopup pop;
    private boolean moveEntity = false;
    private boolean selectHeroPos = false;
    private boolean selectOwlPos = false;
    private JPanel scrollPanel;
    private JScrollBar hBar;
    private JScrollBar vBar;
    private IGameEntity resizeEntity;
    private boolean resizeCollision = false;
    private boolean resizeSouth = false;
    private boolean resizeEast = false;
    private Point lastDrag = new Point();
    Notepad notepad;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapEditor window = new MapEditor();
                window.setVisible(true);
            }
        });
    }

    public MapEditor() {
        this.initialize();
        this.mapData = new MapData();
    }

    private void undoLastAction() {
        if (this.history.size() > 0) {
            this.history.remove(this.history.size() - 1).undoAction(this.mapData, this.mapRenderer);
        }
    }

    private void popUpMenuPressed(ActionEvent e) throws SlickException {
        switch (this.pop.getChoise()) {
            case Delete: {
                this.mapData.getEntities()[this.currentX][this.currentY] = null;
                this.mapRenderer.getEntities().remove(this.currentEntity);
                this.history.add(new Action(this.currentEntity, this.currentEntity.getPosition(), Action.ActionType.Delete));
                break;
            }
            case ChangeDialog: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dialog result;
                        int selected = -1;
                        if (MapEditor.this.currentEntity instanceof OwlTrigger) {
                            selected = ((OwlTrigger)MapEditor.this.currentEntity).getDialogID();
                        } else if (MapEditor.this.currentEntity instanceof DialogTrigger) {
                            selected = ((DialogTrigger)MapEditor.this.currentEntity).getDialogID();
                        } else if (MapEditor.this.currentEntity instanceof Citizen) {
                            selected = ((Citizen)MapEditor.this.currentEntity).getDialogID();
                        } else if (MapEditor.this.currentEntity instanceof BigGuard) {
                            selected = ((BigGuard)MapEditor.this.currentEntity).getDialogID();
                        }
                        Dialog sel = null;
                        if (selected != -1) {
                            sel = MapEditor.this.mapData.getDialogs().get(selected);
                        }
                        if ((result = MapEditor.this.showDialogSelector(sel)) != null) {
                            if (MapEditor.this.currentEntity instanceof OwlTrigger) {
                                ((OwlTrigger)MapEditor.this.currentEntity).setDialog(result);
                            } else if (MapEditor.this.currentEntity instanceof DialogTrigger) {
                                ((DialogTrigger)MapEditor.this.currentEntity).setDialog(result);
                            } else if (MapEditor.this.currentEntity instanceof Citizen) {
                                ((Citizen)MapEditor.this.currentEntity).setDialog(result);
                            } else if (MapEditor.this.currentEntity instanceof BigGuard) {
                                ((BigGuard)MapEditor.this.currentEntity).setDialogID(result.getId());
                            }
                        }
                        MapEditor.this.currentEntity = null;
                    }
                });
                break;
            }
            case ChangeOwlPosition: {
                this.selectOwlPos = true;
                break;
            }
            case Move: {
                this.moveEntity = true;
                break;
            }
            case ChangeCitzen: {
                this.currentEntity.init(null, null);
                break;
            }
        }
        this.remove(this.pop);
        this.pop = null;
    }

    private void mapRightMouseClicked(MouseEvent e) {
        int x = e.getX() / 64;
        int y = e.getY() / 64;
        if (this.mapData.getEntities()[x][y] != null) {
            IGameEntity entity;
            System.out.println("menu pressed!");
            this.currentEntity = entity = this.mapData.getEntities()[x][y];
            this.currentX = x;
            this.currentY = y;
            this.pop = new ObjectPopup(entity, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MapEditor.this.popUpMenuPressed(e);
                    }
                    catch (Exception ex) {
                        System.err.println("Failure in Popup Menu!");
                    }
                }
            });
            this.getContentPane().add(this.pop);
            this.pop.show(this.mapCanvas, this.mapRenderer.getOrigX(), this.mapRenderer.getOrigY());
        }
    }

    private void showMessageDialog(final String msg) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, msg);
            }
        });
    }

    private void mapMouseDragged(MouseEvent e) {
        int dragX = (int)(this.lastDrag.getX() - (double)e.getX());
        int dragY = (int)(this.lastDrag.getY() - (double)e.getY());
        if (e.getButton() == 2) {
            this.hBar.setValue(this.hBar.getValue() + dragX);
            this.vBar.setValue(this.vBar.getValue() + dragY);
        } else if (e.getButton() == 0 && this.resizeEntity != null) {
            if (this.resizeEntity instanceof Trigger) {
                Trigger ent = (Trigger)this.resizeEntity;
                if (this.resizeEast) {
                    ent.setCollisionWidth(ent.getCollisionShape().getWidth() - (float)dragX);
                }
                if (this.resizeSouth) {
                    ent.setCollisionHeight(ent.getCollisionShape().getHeight() - (float)dragY);
                }
            }
            this.lastDrag = (Point)e.getPoint().clone();
        }
    }

    private void mapLeftMouseClicked(MouseEvent e) {
        int x = e.getX() / 64;
        int y = e.getY() / 64;
        if (this.selectOwlPos && this.currentEntity != null) {
            if (this.currentEntity instanceof OwlTrigger) {
                ((OwlTrigger)this.currentEntity).setOwlX(x);
                ((OwlTrigger)this.currentEntity).setOwlY(y);
            }
            this.selectOwlPos = false;
            this.currentEntity = null;
            return;
        }
        if (this.mapData.getEntities()[x][y] != null) {
            this.showMessageDialog("This space is already taken!");
            return;
        }
        if (this.selectHeroPos) {
            this.mapData.getHeroStart().x = x;
            this.mapData.getHeroStart().y = y;
            this.mapRenderer.setHeroStart(this.mapData.getHeroStart());
            this.selectHeroPos = false;
            return;
        }
        if (this.moveEntity && this.currentEntity != null) {
            this.mapData.getEntities()[this.currentX][this.currentY] = null;
            this.mapData.getEntities()[x][y] = this.currentEntity;
            this.history.add(new Action(this.currentEntity, this.currentEntity.getPosition(), Action.ActionType.Move));
            if (this.currentEntity instanceof DoorTrigger && ((DoorTrigger)this.currentEntity).getDoorType() == DoorTrigger.Type.Wood) {
                this.currentEntity.setPosition(new Point2D.Float(x * 64, y * 64 + 32));
            } else {
                this.currentEntity.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
            }
            this.moveEntity = false;
            this.currentEntity = null;
            return;
        }
        if (this.group.getSelection() == null || this.group.getSelection().getActionCommand() == null) {
            return;
        }
        IGameEntity newE = null;
        switch (this.group.getSelection().getActionCommand()) {
            case "Guard": {
                newE = new Guard();
                break;
            }
            case "Dog": {
                newE = new Dog();
                break;
            }
            case "Dwarf": {
                newE = new Dwarf();
                break;
            }
            case "BigGuard": {
                newE = new BigGuard();
                break;
            }
            case "Citizen": {
                newE = new Citizen(1, -1);
                break;
            }
            case "Rock": {
                newE = new Moveable(new Point2D.Float(x * 64 + 32, y * 64 + 32), Moveable.MoveableType.Rock, 1);
                break;
            }
            case "Vase": {
                newE = new Destructible(new Point2D.Float(x * 64 + 32, y * 64 + 32), Destructible.DestructibleType.Vase);
                break;
            }
            case "Shrubbery": {
                newE = new Destructible(new Point2D.Float(x * 64 + 32, y * 64 + 32), Destructible.DestructibleType.Shrubbery);
                break;
            }
            case "Mushroom": {
                newE = new Destructible(new Point2D.Float(x * 64 + 32, y * 64 + 32), Destructible.DestructibleType.Mushroom);
                break;
            }
            case "Key": {
                newE = new Key(new Point2D.Float(x * 64 + 32, y * 64 + 32));
                break;
            }
            case "Potion": {
                newE = new Potion(new Point2D.Float(x * 64 + 32, y * 64 + 32));
                break;
            }
            case "Chest": {
                this.placeChest(x, y);
                return;
            }
            case "Dialog": {
                this.placeDialogTrigger(x, y);
                return;
            }
            case "Message": {
                this.placeMessageTrigger(x, y);
                return;
            }
            case "Owl": {
                this.placeOwlTrigger(x, y);
                return;
            }
            case "Door": {
                newE = new DoorTrigger(null, DoorTrigger.Type.Wood);
                break;
            }
            case "CheckPoint": {
                newE = new Checkpoint(null);
                break;
            }
            case "Torch": {
                newE = new AnimationObject(null, AnimationObject.AnimationObjectType.Torch);
            }
        }
        this.processNewEntity(newE, x, y);
    }

    private void processNewEntity(IGameEntity newE, int x, int y) {
        try {
            if (newE != null) {
                newE.init(null, null);
                if (newE instanceof DoorTrigger && ((DoorTrigger)newE).getDoorType() == DoorTrigger.Type.Wood) {
                    newE.setPosition(new Point2D.Float(x * 64, y * 64 + 32));
                } else {
                    newE.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
                }
                this.mapData.getEntities()[x][y] = newE;
                this.mapRenderer.getEntities().add(newE);
                this.history.add(new Action(newE, newE.getPosition(), Action.ActionType.Create));
            }
        }
        catch (SlickException e1) {
            e1.printStackTrace();
        }
    }

    private void mntmLoadTiledMapPressed(ActionEvent arg0) {
        JFileChooser choose = new JFileChooser();
        choose.setCurrentDirectory(new File("data"));
        choose.setFileFilter(new FileNameExtensionFilter("Tiled Map", "tmx"));
        int result = choose.showDialog(this, "Load");
        if (result != 0) {
            return;
        }
        try {
            this.mapData.loadTiledMap(choose.getSelectedFile().getAbsolutePath());
            this.mapRenderer.setMap(this.mapData.getMap());
            this.mapRenderer.collisionLayer = this.mapData.getCollisionLayer();
            this.mapRenderer.objectLayer = this.mapData.getObjectLayer();
            this.mapCanvas.setBounds(this.scrollPanel.getBounds());
            this.vBar.setMaximum(this.mapData.getMap().getHeight() * 64);
            this.hBar.setMaximum(this.mapData.getMap().getWidth() * 64);
            this.repaint();
        }
        catch (SlickException e) {
            e.printStackTrace();
            this.mapData = new MapData();
        }
    }

    private void mntmLoadMapPressed(ActionEvent e) {
        JFileChooser choose = new JFileChooser();
        choose.setFileFilter(new FileNameExtensionFilter("Map Data", "dkm"));
        choose.setCurrentDirectory(new File("data"));
        int result = choose.showDialog(this, "Load Map");
        if (result != 0) {
            return;
        }
        try {
            LinkedList<IGameEntity> entities = this.mapData.loadXmlMap(choose.getSelectedFile().getPath());
            this.mapRenderer.setMap(this.mapData.getMap());
            this.mapRenderer.setEntities(entities);
            this.mapRenderer.init(null);
            this.mapRenderer.collisionLayer = this.mapData.getCollisionLayer();
            this.mapRenderer.objectLayer = this.mapData.getObjectLayer();
            this.mapRenderer.setHeroStart(this.mapData.getHeroStart());
            this.mapCanvas.setBounds(this.scrollPanel.getBounds());
            this.vBar.setMaximum(this.mapData.getMap().getHeight() * 64);
            this.hBar.setMaximum(this.mapData.getMap().getWidth() * 64);
        }
        catch (Exception ex) {
            this.showMessageDialog(ex.getMessage());
            ex.printStackTrace();
            this.mapData = new MapData();
        }
    }

    private void placeOwlTrigger(final int x, final int y) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dialog result = MapEditor.this.showDialogSelector(null);
                OwlTrigger newE = null;
                if (result != null) {
                    newE = new OwlTrigger(null, true, result.getId(), x, y);
                }
                MapEditor.this.processNewEntity(newE, x, y);
            }
        });
    }

    private void getResizeEntity(MouseEvent e) {
        if (this.mapData == null || this.mapData.getEntities() == null) {
            return;
        }
        this.mapCanvas.setCursor(new Cursor(0));
        this.resizeEntity = null;
        this.resizeEast = false;
        this.resizeSouth = false;
        int x = e.getX() / 64;
        int y = e.getY() / 64;
        IGameEntity ent = this.mapData.getEntities()[x][y];
        if (ent instanceof Trigger) {
            if (ent instanceof Chest || ent instanceof DoorTrigger) {
                return;
            }
            this.resizeEntity = ent;
            if (e.getX() % 64 >= 55 && e.getY() % 64 >= 55) {
                this.mapCanvas.setCursor(new Cursor(5));
                this.resizeEast = true;
                this.resizeSouth = true;
            } else if (e.getX() % 64 >= 55) {
                this.mapCanvas.setCursor(new Cursor(11));
                this.resizeEast = true;
            } else if (e.getY() % 64 >= 55) {
                this.mapCanvas.setCursor(new Cursor(9));
                this.resizeSouth = true;
            }
        }
    }

    private void placeDialogTrigger(final int x, final int y) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dialog result = MapEditor.this.showDialogSelector(null);
                DialogTrigger newE = null;
                if (result != null) {
                    newE = new DialogTrigger(null, false, result.getId());
                }
                MapEditor.this.processNewEntity(newE, x, y);
            }
        });
    }

    private void setLayer(final boolean collision) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object sel;
                Object[] choices = new Object[MapEditor.this.mapData.getMap().getLayerCount()];
                int i = 0;
                while (i < choices.length) {
                    choices[i] = i;
                    ++i;
                }
                String msg = "Select Object-Layer";
                if (collision) {
                    msg = "Select Collision-Layer";
                }
                if ((sel = JOptionPane.showInputDialog(null, msg, "Layer", 3, null, choices, 0)) != null) {
                    int value = (Integer)sel;
                    if (collision) {
                        MapEditor.this.mapData.setCollisionLayer(value);
                        ((MapEditor)MapEditor.this).mapRenderer.collisionLayer = value;
                    } else {
                        MapEditor.this.mapData.setObjectLayer(value);
                        ((MapEditor)MapEditor.this).mapRenderer.objectLayer = value;
                    }
                }
            }
        });
    }

    private void placeMessageTrigger(final int x, final int y) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageTrigger newE = null;
                String message = JOptionPane.showInputDialog(null, "Enter a message to be displayed", "Message Trigger", -1);
                if (message != null && message != "") {
                    newE = new MessageTrigger(null);
                    newE.setMessage(message);
                }
                MapEditor.this.processNewEntity(newE, x, y);
            }
        });
    }

    private void placeChest(final int x, final int y) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Chest newE = null;
                Chest.Item chestOp = (Chest.Item)((Object)JOptionPane.showInputDialog(null, "Select chest content", "Chest", 3, null, (Object[])Chest.Item.values(), (Object)Chest.Item.values()[0]));
                if (chestOp != null) {
                    newE = new Chest(null, chestOp);
                }
                MapEditor.this.processNewEntity(newE, x, y);
            }
        });
    }

    private Dialog showDialogSelector(Dialog selected) {
        Dialog result = null;
        LinkedList<Dialog> choices = new LinkedList<Dialog>();
        for (Dialog d : this.mapData.getDialogs().values()) {
            if (d.isUsed() && !d.equals(selected)) continue;
            choices.add(d);
        }
        result = (Dialog)JOptionPane.showInputDialog(null, "Select Dialog", "Dialog", 3, null, choices.toArray(), selected);
        return result;
    }

    private void initialize() {
        this.setTitle("Dark Knight - Map Editor");
        this.setBounds(100, 100, 861, 397);
        this.setDefaultCloseOperation(2);
        JMenuBar menuBarMain = new JMenuBar();
        this.setJMenuBar(menuBarMain);
        this.group = new ButtonGroup();
        JMenu mnNewMenu = new JMenu("File");
        menuBarMain.add(mnNewMenu);
        JMenuItem mntmNew = new JMenuItem("New");
        mntmNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        mnNewMenu.add(mntmNew);
        JSeparator separator_3 = new JSeparator();
        mnNewMenu.add(separator_3);
        JMenuItem mntmLoadMap = new JMenuItem("Load Map");
        mntmLoadMap.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mnNewMenu.add(mntmLoadMap);
        JMenuItem mntmSaveMap = new JMenuItem("Save Map");
        mntmSaveMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!MapEditor.this.mapData.writeXmlMap(null)) {
                    System.err.println("Error while writing Map file");
                }
            }
        });
        mntmSaveMap.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        mnNewMenu.add(mntmSaveMap);
        JSeparator separator_4 = new JSeparator();
        mnNewMenu.add(separator_4);
        JMenuItem mntmClose = new JMenuItem("Close");
        mntmClose.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        mnNewMenu.add(mntmClose);
        JMenu mnTiledmap = new JMenu("TiledMap");
        menuBarMain.add(mnTiledmap);
        JMenuItem mntmReloadTiledmap = new JMenuItem("Reload TiledMap");
        JMenuItem mntmLoadTiledMap = new JMenuItem("Load TiledMap");
        mnTiledmap.add(mntmLoadTiledMap);
        mnTiledmap.add(mntmReloadTiledmap);
        JSeparator separator_5 = new JSeparator();
        mnTiledmap.add(separator_5);
        JMenuItem mntmChooseObjectlayer = new JMenuItem("Choose Object-Layer");
        mntmChooseObjectlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapEditor.this.setLayer(false);
            }
        });
        JMenuItem mntmSetHeroPosition = new JMenuItem("Set Hero Position");
        mntmSetHeroPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapEditor.this.selectHeroPos = true;
            }
        });
        mnTiledmap.add(mntmSetHeroPosition);
        JSeparator separator_6 = new JSeparator();
        mnTiledmap.add(separator_6);
        mnTiledmap.add(mntmChooseObjectlayer);
        JMenuItem mntmChooseCollisionlayer = new JMenuItem("Choose Collision-Layer");
        mntmChooseCollisionlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapEditor.this.setLayer(true);
            }
        });
        mnTiledmap.add(mntmChooseCollisionlayer);
        JMenu mnEdit = new JMenu("Edit");
        menuBarMain.add(mnEdit);
        JMenuItem mntmUndo = new JMenuItem("Undo");
        mntmUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapEditor.this.undoLastAction();
            }
        });
        mntmUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        mnEdit.add(mntmUndo);
        JMenu mnDisplay = new JMenu("Display");
        menuBarMain.add(mnDisplay);
        JCheckBoxMenuItem chckbxmntmDisplayCollision = new JCheckBoxMenuItem("Display Collision");
        chckbxmntmDisplayCollision.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCheckBoxMenuItem e = (JCheckBoxMenuItem)arg0.getSource();
                MapEditor.this.mapRenderer.setDisplayCollision(e.isSelected());
            }
        });
        mnDisplay.add(chckbxmntmDisplayCollision);
        JCheckBoxMenuItem chckbxmntmDisplayTrigger = new JCheckBoxMenuItem("Display Trigger");
        chckbxmntmDisplayTrigger.setSelected(true);
        mnDisplay.add(chckbxmntmDisplayTrigger);
        JTabbedPane tabbedPaneMain = new JTabbedPane(1);
        this.getContentPane().add((Component)tabbedPaneMain, "Center");
        JSplitPane splitPane = new JSplitPane();
        tabbedPaneMain.addTab("Map", null, splitPane, null);
        splitPane.setOrientation(0);
        this.notepad = new Notepad();
        tabbedPaneMain.addTab("Dialog", this.notepad);
        JMenuBar menuBarObjects = new JMenuBar();
        JToggleButton btnGuard = new JToggleButton("");
        btnGuard.setActionCommand("Guard");
        btnGuard.setIcon(new ImageIcon("ressources\\guard.png"));
        menuBarObjects.add(btnGuard);
        JToggleButton btnDwarf = new JToggleButton("");
        btnDwarf.setActionCommand("Dwarf");
        btnDwarf.setIcon(new ImageIcon("ressources\\dwarf.png"));
        menuBarObjects.add(btnDwarf);
        JToggleButton btnDog = new JToggleButton("");
        btnDog.setActionCommand("Dog");
        btnDog.setIcon(new ImageIcon("ressources\\dog.png"));
        menuBarObjects.add(btnDog);
        JToggleButton tglbtnBigGuard = new JToggleButton("");
        tglbtnBigGuard.setActionCommand("BigGuard");
        tglbtnBigGuard.setIcon(new ImageIcon("ressources\\boss.png"));
        menuBarObjects.add(tglbtnBigGuard);
        JToggleButton btnCitizen = new JToggleButton("");
        btnCitizen.setActionCommand("Citizen");
        btnCitizen.setIcon(new ImageIcon("ressources\\citizen.png"));
        menuBarObjects.add(btnCitizen);
        JSeparator separator = new JSeparator();
        separator.setOrientation(1);
        menuBarObjects.add(separator);
        JToggleButton tglbtnVase = new JToggleButton("Vase");
        tglbtnVase.setActionCommand("Vase");
        menuBarObjects.add(tglbtnVase);
        JToggleButton tglbtnShrubbery = new JToggleButton("Shrubbery");
        tglbtnShrubbery.setActionCommand("Shrubbery");
        menuBarObjects.add(tglbtnShrubbery);
        JToggleButton tglbtnMushroom = new JToggleButton("Mushroom");
        tglbtnMushroom.setActionCommand("Mushroom");
        menuBarObjects.add(tglbtnMushroom);
        JSeparator separator_1 = new JSeparator();
        separator_1.setOrientation(1);
        menuBarObjects.add(separator_1);
        JToggleButton tglbtnRock = new JToggleButton("Rock");
        tglbtnRock.setActionCommand("Rock");
        menuBarObjects.add(tglbtnRock);
        JToggleButton tglbtnTorch = new JToggleButton("Torch");
        tglbtnTorch.setActionCommand("Torch");
        menuBarObjects.add(tglbtnTorch);
        JSeparator separator_2 = new JSeparator();
        separator_2.setOrientation(1);
        menuBarObjects.add(separator_2);
        JToggleButton tglbtnKey = new JToggleButton("Key");
        tglbtnKey.setActionCommand("Key");
        menuBarObjects.add(tglbtnKey);
        JToggleButton tglbtnPotion = new JToggleButton("Potion");
        tglbtnPotion.setActionCommand("Potion");
        menuBarObjects.add(tglbtnPotion);
        JToggleButton tglbtnChest = new JToggleButton("Chest");
        tglbtnChest.setActionCommand("Chest");
        menuBarObjects.add(tglbtnChest);
        this.scrollPanel = new JPanel(new BorderLayout());
        this.scrollPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                MapEditor.this.mapRenderer.getViewPort().setWidth(MapEditor.this.scrollPanel.getWidth() - MapEditor.this.vBar.getWidth());
                MapEditor.this.mapRenderer.getViewPort().setHeight(MapEditor.this.scrollPanel.getHeight() - MapEditor.this.hBar.getHeight());
            }
        });
        this.hBar = new JScrollBar(0);
        this.hBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent arg0) {
                MapEditor.this.mapRenderer.getViewPort().setX(MapEditor.this.hBar.getValue());
            }
        });
        this.vBar = new JScrollBar(1);
        this.vBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent arg0) {
                MapEditor.this.mapRenderer.getViewPort().setY(MapEditor.this.vBar.getValue());
            }
        });
        this.scrollPanel.add((Component)this.hBar, "South");
        this.scrollPanel.add((Component)this.vBar, "East");
        splitPane.setRightComponent(this.scrollPanel);
        this.group.add(tglbtnRock);
        this.group.add(tglbtnChest);
        this.group.add(tglbtnKey);
        this.group.add(tglbtnMushroom);
        this.group.add(tglbtnPotion);
        this.group.add(tglbtnTorch);
        this.group.add(tglbtnShrubbery);
        this.group.add(tglbtnVase);
        this.group.add(btnDog);
        this.group.add(btnGuard);
        this.group.add(btnDwarf);
        this.group.add(btnCitizen);
        this.group.add(tglbtnBigGuard);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab("Objects / Enemies", menuBarObjects);
        splitPane.setLeftComponent(tabbedPane);
        JMenuBar menuBarTrigger = new JMenuBar();
        tabbedPane.addTab("Trigger", menuBarTrigger);
        JToggleButton tglbtnOwl = new JToggleButton("Owl");
        tglbtnOwl.setHorizontalAlignment(2);
        this.group.add(tglbtnOwl);
        tglbtnOwl.setActionCommand("Owl");
        menuBarTrigger.add(tglbtnOwl);
        JToggleButton tglbtnMessage = new JToggleButton("Message");
        tglbtnMessage.setActionCommand("Message");
        this.group.add(tglbtnMessage);
        menuBarTrigger.add(tglbtnMessage);
        JSeparator separator_7 = new JSeparator();
        menuBarTrigger.add(separator_7);
        JToggleButton tglbtnCheckpoint = new JToggleButton("CheckPoint");
        tglbtnCheckpoint.setActionCommand("CheckPoint");
        this.group.add(tglbtnCheckpoint);
        menuBarTrigger.add(tglbtnCheckpoint);
        JToggleButton tglbtnDoor = new JToggleButton("Door");
        tglbtnDoor.setHorizontalAlignment(2);
        this.group.add(tglbtnDoor);
        tglbtnDoor.setActionCommand("Door");
        menuBarTrigger.add(tglbtnDoor);
        try {
            this.mapRenderer = new MapRenderer("");
            this.mapCanvas = new CanvasGameContainer(this.mapRenderer);
            this.scrollPanel.add((Component)this.mapCanvas, "Center");
            this.mapCanvas.getContainer().setTargetFrameRate(25);
            this.mapCanvas.getContainer().setAlwaysRender(true);
            this.mapCanvas.start();
        }
        catch (SlickException e) {
            this.showMessageDialog(e.getMessage());
            e.printStackTrace();
        }
        JToggleButton tglbtnDialog = new JToggleButton("Dialog");
        tglbtnDialog.setHorizontalAlignment(2);
        mntmLoadMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapEditor.this.mntmLoadMapPressed(e);
                MapEditor.this.notepad.setMapData(MapEditor.this.mapData);
                MapEditor.this.notepad.getDialogData();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                super.windowClosing(arg0);
                MapEditor.this.mapCanvas.getContainer().exit();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                System.out.println("Window Closed!");
                System.exit(0);
            }
        });
        mntmLoadTiledMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapEditor.this.mntmLoadTiledMapPressed(arg0);
            }
        });
        mntmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapEditor.this.mapData = new MapData();
                MapEditor.this.mapRenderer.setMap(null);
            }
        });
        this.mapRenderer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MapEditor.this.mapData == null || MapEditor.this.mapData.getEntities() == null) {
                    return;
                }
                if (MapEditor.this.pop != null) {
                    MapEditor.this.pop.setVisible(false);
                    MapEditor.this.remove(MapEditor.this.pop);
                    MapEditor.this.pop = null;
                }
                if (e.getButton() == 0) {
                    MapEditor.this.mapLeftMouseClicked(e);
                } else if (e.getButton() == 1) {
                    MapEditor.this.mapRightMouseClicked(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MapEditor.this.lastDrag = e.getPoint();
                MapEditor.this.getResizeEntity(e);
                if (MapEditor.this.resizeEast || MapEditor.this.resizeSouth) {
                    MapEditor.this.resizeCollision = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MapEditor.this.resizeEast || MapEditor.this.resizeSouth) {
                    MapEditor.this.resizeCollision = false;
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                MapEditor.this.mapMouseWheelMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                MapEditor.this.mapMouseDragged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MapEditor.this.resizeCollision || MapEditor.this.mapData.getEntities() == null) {
                    return;
                }
                MapEditor.this.getResizeEntity(e);
            }
        });
    }

    protected void mapMouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollAmount() > 0) {
            this.mapRenderer.increaseZoom();
        } else {
            this.mapRenderer.decreaseZoom();
        }
    }
}

